<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function logout(Request $request)
    {
        Session::flush();

        Auth::logout();

        return redirect('login');

    }


    public function newLogin(Request $request)
    {

        // Validate the form data
        $this->validate($request, [
            'phone'   => 'required',
            'password' => 'required'
        ]);
         $user = User::where('phone', $request->phone)->first();
         if($user){
        
            \Illuminate\Support\Facades\Auth::login($user);

            return redirect('/dashboard');
        }else{
                    return redirect()->back()->with('error', 'Login credentials are not correct');

        }

    }
}
