<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Redirect;
use URL;
use App\Models\User;
use App\Models\Expense;
use Auth;

class ExpensesController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $expenses =  Expense::orderBy('created_at', 'desc')->get();
        return view('admin.expenses.index', compact('expenses'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $users =  User::orderBy('created_at', 'desc')->get();
        return view('admin.expenses.create', compact('users'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //



        $validatedData = $request->validate([
           'amount' => 'required|max:255',
           'description' => 'required',
           'date' => 'required',
           'user_id' => 'required',

        ]);
        $expense = new Expense;
        $expense->amount = $request->input('amount');
        $expense->description= $request->input('description');
        $expense->date = $request->input('date');
        $expense->user_id =  $request->input('user_id');
        $expense->save();
        if($expense->save()){
            $route = URL::to('admin/expenses');
            return redirect($route)->with('success', 'expense added successfully');
        }else{
             return redirect()->back()->with('error', 'Failed please try again');
        }


    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $expense = Expense::where('id', $id)->first();
        return view('admin/expenses.edit', compact('expense'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        
        $validatedData = $request->validate([
           'amount' => 'required|max:255',
           'description' => 'required',
           'date' => 'required',
            'user_id' => 'required',

        ]);
       
        $amount = $request->input('amount');
        $description= $request->input('description');
        $date = $request->input('date');
        $added_by = $request->input('user_id');
        $ok = Expense::where('id', $id)->update([
            'amount' => $amount,
            'description' => $description,
            'date' => $date,
            'user_id' => $added_by]);

      
        if($ok){
            $route = URL::to('admin/expenses');
            return redirect($route)->with('success', 'expense updated successfully');
        }else{
             return redirect()->back()->with('error', 'Failed please try again');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        if(!$id){
            $route = URL::to('admin/expenses');
            return redirect($route);
        }
       
            $ok = Expense::where('id', $id)->delete($id);
            if($ok){
                $route = URL::to('admin/expenses');
                return redirect($route)->with('success', 'Expense  deleted successfully');
            }else{
                 return redirect()->back()->with('error', 'Failed please try again');
            }

    }
}
