<?php

namespace App\Http\Controllers;

use App\Models\Message;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Subscription;
use Carbon\Carbon;

class InvoiceController extends Controller
{
    //
    public function index()
    {
        $subscriptions = Subscription::whereDate('end_date', '<=', Carbon::today()->addDays(3))->get();

        return view('admin.invoices.index',compact('subscriptions'));
    }

    public function invoiceMessage($id)
    {
        return view('admin.invoices.message',compact('id'));
    }

    public function sendInvoiceMessage(Request $request)
    {
        $smsData =  $request->validate([
            'user' => 'required',
            'message' => 'required',
        ]);
        $u = User::where('id', $request->user)->first();
        //send sms
        $sm = new Message;
        $send = $sm->sendSms($u->phone,$request->message);

        if($send)
        {
            Message::create($smsData);
            return redirect()->back()->with('success','Invoice message sent successfully');
        }else{
            return redirect()->back()->with('error','Failed please try again');

        }

    }


}
