<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Ticket;
use Auth;
use App\Models\Region;
use App\Models\User;
use App\Models\Message;
class TicketController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //

        if(Auth::user()->role== 1){

             $tickets = Ticket::orderBy('created_at','DESC')->get();

            return view('admin.tickets.index',compact('tickets'));

        }
        if(Auth::user()->role== 2){
             $tickets = Ticket::where('user_id',Auth::user()->id)->orderBy('created_at','DESC')->get();

            return view('user.tickets.index',compact('tickets'));

        }
        if(Auth::user()->role== 3){
             $tickets = Ticket::orderBy('created_at','DESC')->get();

            return view('user.tickets.index',compact('tickets'));

        }



    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
         if(Auth::user()->role== 1 ||Auth::user()->role == 3){

            $regions = Region::orderBy('name','ASC')->get();
            $users = User::where('role',2)->get();

            return view('admin.tickets.create',compact('regions','users'));

        }
        if(Auth::user()->role== 2){


            return view('user.tickets.create');

        }



    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $users = User::where('role', 3)->orWhere('role',1)->get();



         $userData =  $request->validate([
            'subject' => ['required'],
            'message' => ['required'],

        ]);

        if(Auth::user()->role== 1 || Auth::user()->role == 3){


            $ticket = new Ticket;
             $ticket->subject  = $request->input('subject');
             $ticket->message = $request->input('message');
             $ticket->user_id = $request->input('user');

            $user2 = User::where('id',$request->input('user'))->first();



             $ok = $ticket->save();

             $route = URL('/tickets');
            if($ok)
            {
                foreach ($users as $user) {
                     $sm = new Message;
                    $message = "A subscriber has created an issue on ".$user2->location." please login to the portal for more information";
                    $send = $sm->sendSms($user->phone, $message);

                }
                
                return redirect($route)->with('success','Ticket created successfully');

            }else{
                return redirect($route)->with('error','something went wrong');

            }



        }
        if(Auth::user()->role== 2){

            $ticket = new Ticket;
             $ticket->subject  = $request->input('subject');
             $ticket->message = $request->input('message');
             $ticket->user_id = Auth::user()->id;

             $ok = $ticket->save();

             $route = URL('/tickets');
            if($ok)
            {
                 foreach ($users as $user) {
                     $sm = new Message;
                    $message = "A subscriber has created an issue on " .Auth::user()->location." please login to the portal for more information";
                    $send = $sm->sendSms($user->phone, $message);

                }

                return redirect($route)->with('success','Ticket created successfully. One of our service staff will get back to you shortly');

            }else{
                return redirect($route)->with('error','something went wrong');

            }


        }


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        $ticket = Ticket::where('id',$id)->first();

        if(Auth::user()->role== 2){

            return view('user.tickets.show', compact('ticket'));
        }
        if(Auth::user()->role== 1 ||Auth::user()->role == 3){

            return view('admin.tickets.show', compact('ticket'));
        }


    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //

         $ticket = Ticket::where('id',$id)->first();

        if(Auth::user()->role== 2){

            return view('user.tickets.edit', compact('ticket'));
        }
        if(Auth::user()->role== 1 ||Auth::user()->role == 3){

            return view('admin.tickets.edit', compact('ticket'));
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $userData =  $request->validate([
            'subject' => ['required'],
            'message' => ['required'],

        ]);

         if(Auth::user()->role== 1){

             $subject  = $request->input('subject');
             $message = $request->input('message');
             $region = $request->input('region');

             $ok = Ticket::where('id',$id)->update([
                'subject' => $subject,
                'message' => $message,
                'region' => $region
            ]);

             $route = URL('/tickets');
            if($ok)
            {
                return redirect($route)->with('success','Ticket updated successfully');

            }else{
                return redirect($route)->with('error','something went wrong');

            }
        }
         if(Auth::user()->role== 2){

            $subject  = $request->input('subject');
             $message = $request->input('message');
             $user_id = Auth::user()->id;

             $ok = Ticket::where('id',$id)->update([
                'subject' => $subject,
                'message' => $message,
                'user_id' => $user_id
            ]);

             $route = URL('/tickets');
            if($ok)
            {
                return redirect($route)->with('success','Ticket updated successfully. One of our service staff will get back to you shortly');

            }else{
                return redirect($route)->with('error','something went wrong');

            }


        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $route = URL('/tickets');
        $ticket = Ticket::where('id',$id)->first();
        $ok = $ticket->delete();
        if($ok)
        {
            return redirect($route)->with('success','Ticket deleted successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }
    }

    public function markResolved($id)
    {

         $route = URL('/tickets');
        $ticket = Ticket::where('id',$id)->first();
        $ok = $ticket->update([
            'status' => 1
        ]);

        $user = User::where('id',$ticket->user_id)->first();
        if($ok)
        {
             $sm = new Message;
            $message = "The issue has been resolved thanks";
            $send = $sm->sendSms($user->phone, $message);
            return redirect($route)->with('success','Ticket marked as resolved');

        }else{
            return redirect($route)->with('error','something went wrong');

        }

    }
}
