@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Expenses</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Expenses</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>



        </div>
        @if(session('success'))
            <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                {{ session('error') }}
            </div>
        @endif
        <section id="multiple-column-form">
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Add New</h4>
                            <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                Back</a>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                             <form action="{{url('admin/expense/post')}}" method="post">
              @csrf
                <div class="form-group">
                  <label class="control-label">Amount</label>
                   <span class="input-label-secondary" style="color: red;">*</span>
                  <input class="form-control @error('amount') is-invalid @enderror" value="{{old('amount')}}" name="amount" type="text" placeholder="Enter amount"  required autofocus>
                  @error('amount')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                </div>
                 <div class="form-group">
                  <label class="control-label">Date</label>
                   <span class="input-label-secondary" style="color: red;">*</span>
                  <input class="form-control @error('date') is-invalid @enderror" value="{{old('date')}}" name="date" type="date" placeholder="Select date"  required autofocus>
                  @error('date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                </div>
                <div class="form-group">
                  <label class="control-label">User</label>
                   <span class="input-label-secondary" style="color: red;">*</span>
                  <select class="form-control @error('user_id') is-invalid @enderror" name="user_id" id="exampleSelect1" required="">
                      <option value="">Select User</option>
                      @php
                      $sps = App\Models\User::where('role','!=',2)->orderBy('created_at', 'desc')->get();

                      @endphp
                      @foreach($sps as $sp)
                      <option value="{{$sp->id}}">{{$sp->name}}</option>
                     @endforeach
                    </select>
                    @error('user_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                </div>

                 <div class="form-group">
                  <label class="control-label">Description</label>
                   <span class="input-label-secondary" style="color: red;">*</span>
                  <textarea class="form-control @error('name') is-invalid @enderror" rows="4" name="description" placeholder="Enter description" required autofocus>{{old('description')}}</textarea>
                  @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                </div>

                 
                 <div class="col-12 d-flex justify-content-end">
                                            <button type="submit"
                                                    class="btn btn-primary me-1 mb-1">Submit</button>
                                            
                                        </div>
                
               
                </div>
                
               
              </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

