@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>
       @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif


        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Hotspot Packages</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Hotspot Packages</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        All Hotspot Packages
                        <a href="{{url('packages/new')}}" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Package</a>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Size</th>
                                <th>Price</th>
                                <th>Upload speed</th>
                                <th>Upload speed</th>
                                <th>Devices</th>
                                <th>Time</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>

                                @foreach($packages as $package)
                                    <tr>
                                <td>{{$package->name}}</td>
                                <td>{{$package->size}} MB</td>
                                <td>Ksh {{$package->price}}</td>
                                <td>{{$package->upload_speed}} Mpbs</td>
                                    <td>{{$package->download_speed}} Mbps</td>
                                    <td>{{$package->devices}}</td>
                                    <td>{{$package->time}} {{$package->unit}}</td>

                                <td>
                                    @if($package->status == 1)
                                    <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>

                                <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                <a class="dropdown-item" href="{{url('package/edit',$package->id)}}"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                    Edit</a>
                                                @if($package->status == 1)
                                                <a class="dropdown-item" href="{{url('package/deactivate',$package->id)}}"><i class="fa fa-ban" aria-hidden="true" style="color: #7c8db5;"></i>

                                                    Deactivate</a>
                                                @else
                                                    <a class="dropdown-item" href="{{url('package/activate',$package->id)}}"><i class="fa fa-undo" aria-hidden="true" style="color: #7c8db5;"></i>

                                                        Activate</a>
                                                    @endif

                                                <a class="dropdown-item" href="{{url('package/delete',$package->id)}}"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                    </tr>
                                @endforeach


                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
