@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Sms</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">New Message</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>



        </div>
        <section id="multiple-column-form">
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Send Invoice Message</h4>
                            <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                Back</a>
                        </div>
                        <div class="card-content">
                            @php
                            $sub = App\Models\Subscription::where('id',$id)->where('status',1)->first();
                                $p = App\Models\User::where('phone', $sub->username)->first();
                                $pac = App\Models\Package::where('id',$sub->package)->first();

                            @endphp
                            <div class="card-body">
                                <form class="form" method="POST" action="{{url('admin/invoices/message')}}">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Customer</label>

                                                 <input type="text" id="first-name-column" class="form-control  @error('user') is-invalid @enderror"
                                                       placeholder="" name="user" value="{{$p->id}}" hidden="">

                                                <input type="text" id="first-name-column" class="form-control  @error('user') is-invalid @enderror"
                                                       placeholder="" name="user" value="{{$p->name}}">
                                                @error('user')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-12 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Message</label>
                                                <textarea class="form-control form-select @error('message') is-invalid @enderror" name="message" id="exampleFormControlTextarea1"
                                                          rows="3">Dear {{$p->name}} your subscription expires in 3 days pay {{$pac->price}}  to Acc no 8767890 to avoid disconnection thanks!</textarea>
                                                @error('message')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>



                                        <div class="col-12 d-flex justify-content-end">
                                            <button type="submit"
                                                    class="btn btn-primary me-1 mb-1">Submit</button>
                                            <button type="reset"
                                                    class="btn btn-light-secondary me-1 mb-1">Reset</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
