@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>
      

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Settings</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Settings</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
 @if(session('success'))
            <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                {{ session('error') }}
            </div>
        @endif


        </div>
        <section id="multiple-column-form">
            <div class="row match-height">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Update Settings</h4>
                            <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                Back</a>
                        </div>
                        <div class="card-content">
                            <div class="card-body">
                                <form class="form" method="POST" action="{{url('admin/settings/store')}}">
                                    @csrf
                                    <div class="row">
                                         <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Mikrotik Host Ip</label>
                                                <input type="text" id="first-name-column" class="form-control  @error('mikrotik_user') is-invalid @enderror"
                                                       placeholder="" name="mikrotik_host" value="{{ $setting->mikrotik_host }}">
                                                @error('mikrotik_host')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Mikrotik User</label>
                                                <input type="text" id="first-name-column" class="form-control  @error('mikrotik_user') is-invalid @enderror"
                                                       placeholder="" name="mikrotik_user" value="{{ $setting->mikrotik_user }}">
                                                @error('mikrotik_user')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Mikrotik Password</label>
                                                <input type="text" id="first-name-column" class="form-control  @error('mikrotik_password') is-invalid @enderror"
                                                       placeholder="Mikrotik Password" name="mikrotik_password" value="{{ $setting->mikrotik_password }}">
                                                @error('mikrotik_password')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="first-name-column">Mikrotik Port</label>
                                                <input type="text" id="first-name-column" class="form-control  @error('mikrotik_port') is-invalid @enderror"
                                                       placeholder="Mikrotik Port" name="mikrotik_port" value="{{ $setting->mikrotik_port }}">
                                                @error('mikrotik_port')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Mpesa Consumer Key</label>
                                                <input type="text" id="city-column" class="form-control  @error('mpesa_consumerkey') is-invalid @enderror"
                                                       placeholder="" name="mpesa_consumerkey" value="{{$setting->mpesa_consumerkey}}">
                                                @error('mpesa_consumerkey')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="city-column">Mpesa Consumer Secret </label>
                                                <input type="text" id="city-column" class="form-control  @error('mpesa_consumersecret') is-invalid @enderror"
                                                       placeholder="" name="mpesa_consumersecret" value="{{$setting->mpesa_consumersecret}}">
                                                @error('mpesa_consumersecret')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Mpesa Passkey</label>
                                                <input type="text" id="country-floating" class="form-control  @error('mpesa_passkey') is-invalid @enderror"
                                                       name="mpesa_passkey" placeholder="" value="{{ $setting->mpesa_passkey }}">
                                                @error('mpesa_passkey')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                         <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Mpesa Intiator Username</label>
                                                <input type="text" id="country-floating" class="form-control  @error('mpesa_initiator_username') is-invalid @enderror"
                                                       name="mpesa_initiator_username" placeholder="" value="{{ $setting->mpesa_initiator_username }}">
                                                @error('mpesa_initiator_username')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                         <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Mpesa Shortcode</label>
                                                <input type="text" id="country-floating" class="form-control  @error('mpesa_shortcode') is-invalid @enderror"
                                                       name="mpesa_shortcode" placeholder="" value="{{ $setting->mpesa_shortcode }}">
                                                @error('mpesa_shortcode')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Mpesa Intiator Password</label>
                                                <input type="text" id="country-floating" class="form-control  @error('mpesa_initiator_password') is-invalid @enderror"
                                                       name="mpesa_initiator_password" placeholder="" value="{{ $setting->mpesa_initiator_password }}">
                                                @error('mpesa_initiator_password')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Afrikastalking Sms Username</label>
                                                <input type="text" id="country-floating" class="form-control  @error('sms_username') is-invalid @enderror"
                                                       name="sms_username" placeholder="" value="{{ $setting->sms_username }}">
                                                @error('sms_username')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                         <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Sms Api Key</label>
                                                <input type="text" id="country-floating" class="form-control  @error('sms_apikey') is-invalid @enderror"
                                                       name="sms_apikey" placeholder="" value="{{ $setting->sms_apikey }}">
                                                @error('sms_apikey')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                         <div class="col-md-6 col-12">
                                            <div class="form-group">
                                                <label for="country-floating">Sms Shortcode</label>
                                                <input type="text" id="country-floating" class="form-control  @error('sms_shortcode') is-invalid @enderror"
                                                       name="sms_shortcode" placeholder="" value="{{ $setting->sms_shortcode}}">
                                                @error('sms_shortcode')
                                                <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                                @enderror
                                            </div>
                                        </div>




                                        <div class="col-12 d-flex justify-content-end">
                                            <button type="submit"
                                                    class="btn btn-primary me-1 mb-1">Submit</button>
                                            <button type="reset"
                                                    class="btn btn-light-secondary me-1 mb-1">Reset</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
