@extends('layouts.app')
@section('content')
    <div id="main">
                <header class="mb-3">
                    <a href="#" class="burger-btn d-block d-xl-none">
                        <i class="bi bi-justify fs-3"></i>
                    </a>
                </header>

                <div class="page-heading">
                    <div class="page-title">
                        <div class="row">
                            <div class="col-12 col-md-6 order-md-1 order-last">
                                <h3>Users</h3>
                                <p class="text-subtitle text-muted"></p>
                            </div>
                            <div class="col-12 col-md-6 order-md-2 order-first">
                                <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                                    <ol class="breadcrumb">
                                        <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                        <li class="breadcrumb-item active" aria-current="page">Users</li>
                                    </ol>
                                </nav>
                            </div>
                        </div>
                    </div>



                </div>
                <section id="multiple-column-form">
                    <div class="row match-height">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">User Details</h4>
                                    <a onclick="history.back()" class="btn btn-primary pull-right"><i class="fa fa-arrow-left" aria-hidden="true"></i>
                                        Back</a>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">

                                        <div class="card-group">


                                            <div class="card">

                                                 <span class="m-lg-1">Account Information</span>

                                                <div class="card-content">


                                                    <div class="card-body">
                                                        <h6 class="card-title">Full Names</h6>
                                                        <p class="card-text">
                                                            {{$user->name}}
                                                        </p>
                                                        <h6 class="card-title">Phone</h6>
                                                        <p class="card-text">
                                                            {{$user->phone}}
                                                        </p> <h6 class="card-title">Email</h6>
                                                        <p class="card-text">
                                                            {{$user->email}}
                                                        </p>
                                                        @php
                                                            $inputDateTime = $user->created_at;
                                                        $datep = Illuminate\Support\Carbon::parse($inputDateTime);
                                                        $days_ = $datep->longAbsoluteDiffForHumans(Illuminate\Support\Carbon::now());
                                                        $daysAgo = $days_;

                                                        @endphp
                                                        </p> <h6 class="card-title">Created At</h6>
                                                        <p class="card-text">
                                                          {{$daysAgo}}
                                                        </p>


                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card">
                                            <br>
                                                <div class="card-content">
                                                    @php
                                                        $sub = App\Models\Subscription::where('username',$user->phone)->first();
                                                $admin = App\Models\User::where('role',1)->first();
                                                if($sub){
                                                      $pac = App\Models\Package::where('id',$sub->package)->first();
                                                      $package = $pac->name;

                                                }else{
                                                    $package = 'Not Subscribed';
                                                }

                                                    @endphp

                                                    <div class="card-body">
                                                        <h6 class="card-title">Package</h6>
                                                        <p class="card-text">
                                                         {{$package}}
                                                        </p>
                                                    </div>
                                                     <div class="card-body">
                                                        <h6 class="card-title">Start Date</h6>
                                                        <p class="card-text">
                                                         {{$sub->start_date}}
                                                        </p>
                                                    </div>
                                                    <div class="card-body">
                                                        <h6 class="card-title">End Date</h6>
                                                        <p class="card-text">
                                                         {{$sub->end_date}}
                                                        </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card">
                                                <div class="card-content">
                                                    <span class="m-lg-3">User Information</span>
                                                    <div class="card-body">

                                                        <p class="card-text">

                                                        </p>
                                                        @if(!empty($secret))
                                                            @foreach($secret as $res)
                                                                <h6 class="card-title">Username</h6>
                                                                <p class="card-text">
                                                                    {{$res['name']}}
                                                                </p>
                                                                <h6 class="card-title">Password</h6>
                                                                <p class="card-text">
                                                                    {{$res['password']}}
                                                                </p>
                                                                <h6 class="card-title">Profile</h6>
                                                                <p class="card-text">
                                                                    {{$res['profile']}}
                                                                </p>
                                                                <h6 class="card-title">Secret</h6>
                                                                <p class="card-text">
                                                                    {{$res['service']}}
                                                                </p>
                                                            @endforeach
                                                        @else
                                                            <h6 class="card-title">Username</h6>
                                                            <p class="card-text">

                                                            </p>
                                                            <h6 class="card-title">Password</h6>
                                                            <p class="card-text">

                                                            </p>
                                                            <h6 class="card-title">Profile</h6>
                                                            <p class="card-text">

                                                            </p>
                                                            <h6 class="card-title">Secret</h6>
                                                            <p class="card-text">

                                                            </p>
                                                        @endif



                                                    </div>
                                                </div>
                                            </div>
                                            <div class="card">
                                                <div class="card-content">

                                                    <div class="card-body">
                                                        <h4 class="card-title"></h4>
                                                        <p class="card-text">

                                                        </p>


                                                        <small class="text-muted"></small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>




@endsection
