@extends('layouts.auth')

@section('content')

<div id="auth">

    <div class="row h-100">
        <div class="col-lg-5 col-12">
            <div id="auth-left">
                <div class="auth-logo text-center" style="margin-bottom:30px !important;">
                    <a href="{{url('/')}}"><img src="{{url('/assets/images/logo/logo_black.png')}}" width="200" height="600" alt="Logo"></a>
                </div>
                <h6 class="text-center">Stay Connected Stay Swift.</h6>
                <br>
                <h5 class="text-center">Sign In To Your Account.</h5>
                <br>

                 @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                    {{ session('error') }}
                </div>
            @endif

                <form method="POST" action="{{ route('user.login') }}">
                    @csrf
                    <div class="form-group position-relative has-icon-left mb-4">
                        <input type="text" class="form-control form-control-xl @error('phone') is-invalid @enderror" name="phone" value="{{ old('phone') }}" placeholder="Registered Phone">
                        <div class="form-control-icon">
                            <i class="fa fa-phone"></i>
                        </div>
                        @error('phone')
                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                        @enderror
                    </div>
                    <div class="form-group position-relative has-icon-left mb-4">
                        <input type="password" class="form-control form-control-xl @error('password') is-invalid @enderror" name="password" placeholder="Password">
                        <div class="form-control-icon">
                            <i class="bi bi-shield-lock"></i>
                        </div>
                        @error('password')
                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                        @enderror
                    </div>
                   <!--  <div class="form-check form-check-lg d-flex align-items-end">
                        <input class="form-check-input me-2" type="checkbox" value="" id="flexCheckDefault">
                        <label class="form-check-label text-gray-600" for="flexCheckDefault">
                            Keep me logged in
                        </label>
                    </div> -->
                    <button class="btn btn-primary btn-block btn-lg shadow-lg mt-5">Log in</button>
                </form>
                <div class="text-center mt-5 text-lg fs-4">
                   <!--  <p class="text-gray-600">Don't have an account? <a href="{{ route('register') }}"
                                                                       class="font-bold">Sign
                            up</a>.</p> -->
                    <p><a class="font-bold" href="{{ route('password.request') }}">Forgot password?</a>.</p>
                </div>
            </div>
        </div>
        <div class="col-lg-7 d-none d-lg-block">
            <div id="auth-right">

            </div>
        </div>
    </div>

</div>
@endsection
