<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/auth/logout', [App\Http\Controllers\Auth\LoginController::class, 'logout'])->name('user.logout');

Route::post('/auth/login', [App\Http\Controllers\Auth\LoginController::class, 'newLogin'])->name('user.login');



Route::get('/', [App\Http\Controllers\DashboardController::class, 'index'])->name('home');
Route::get('/dashboard', [App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');

//user
// Route::get('/subscribe', [App\Http\Controllers\SubscriptionController::class, 'subscribe'])->name('user.subscribe');

Route::post('/auth/register', [App\Http\Controllers\Auth\RegisterController::class, 'registerUsers'])->name('user.register');

//admin routes
Route::get('/hotspot/users', [App\Http\Controllers\HotspotController::class, 'index'])->name('hotspot.users');
Route::get('/hotspot/user/create', [App\Http\Controllers\HotspotController::class, 'createProfile'])->name('hotspot.user.create');
Route::post('/hotspot/user/store', [App\Http\Controllers\HotspotController::class, 'storeProfile'])->name('hotspot.user.store');
Route::get('/hotspot/subscribe/{id}', [App\Http\Controllers\HotspotController::class, 'subscribeHotspot'])->name('user.subscribe');


Route::get('/users', [App\Http\Controllers\UsersController::class, 'index'])->name('users.all');
Route::get('/user/view/{id}', [App\Http\Controllers\UsersController::class, 'show'])->name('users.view');
Route::get('/user/hotspot/edit/{id}', [App\Http\Controllers\HotspotController::class, 'editProfile'])->name('users.hotspot.edit');
Route::post('/user/hotspot/update/{id}', [App\Http\Controllers\HotspotController::class, 'updateProfile'])->name('users.hotspot.update');
Route::get('/user/delete/{id}', [App\Http\Controllers\HotspotController::class, 'deleteProfile'])->name('users.hotspot.delete');

Route::get('/packages/hotspot', [App\Http\Controllers\HotspotController::class, 'hotspotPackages'])->name('hotspot.packages');
Route::get('/packages/new', [App\Http\Controllers\PackagesController::class, 'createPackage'])->name('package.create');
Route::post('/package/store', [App\Http\Controllers\PackagesController::class, 'storePackage'])->name('package.store');
Route::get('/package/edit/{id}', [App\Http\Controllers\PackagesController::class, 'editPackage'])->name('package.edit');
Route::post('/package/update/{id}', [App\Http\Controllers\PackagesController::class, 'updatePackage'])->name('package.update');
Route::get('/package/delete/{id}', [App\Http\Controllers\PackagesController::class, 'deletePackage'])->name('package.delete');
Route::get('/package/deactivate/{id}', [App\Http\Controllers\PackagesController::class, 'deactivatePackage'])->name('package.deactivate');
Route::get('/package/activate/{id}', [App\Http\Controllers\PackagesController::class, 'activatePackage'])->name('package.activate');


Route::get('/packages/ppoe', [App\Http\Controllers\PpoeController::class, 'PPoepackages'])->name('ppoe.packages');
Route::get('/payments', [App\Http\Controllers\PaymentsController::class, 'index'])->name('payments.index');
Route::get('/payments/new', [App\Http\Controllers\PaymentsController::class, 'create'])->name('payments.create');
Route::get('/payment/void/{id}', [App\Http\Controllers\PaymentsController::class, 'void'])->name('payments.void');
Route::get('/payments/edit/{id}', [App\Http\Controllers\PaymentsController::class, 'update'])->name('payments.update');
Route::post('/payments/store', [App\Http\Controllers\PaymentsController::class, 'store'])->name('payments.store');
Route::get('/payments/update/{id}', [App\Http\Controllers\PaymentsController::class, 'update'])->name('payments.update');


Route::get('/sms', [App\Http\Controllers\SmsController::class, 'index'])->name('sms.index');
Route::get('/sms/new', [App\Http\Controllers\SmsController::class, 'create'])->name('sms.create');
Route::post('/sms/store', [App\Http\Controllers\SmsController::class, 'store'])->name('sms.store');
Route::post('/sms/store/region', [App\Http\Controllers\SmsController::class, 'storeRegion'])->name('sms.store.region');
Route::post('/sms/store/ticket/{id}', [App\Http\Controllers\SmsController::class, 'storeSmsTicket'])->name('sms.store.ticket');
Route::get('/sms/create/ticket/{id}', [App\Http\Controllers\SmsController::class, 'createSmsTicket'])->name('sms.create.ticket');

Route::get('/sms/delete/{id}', [App\Http\Controllers\SmsController::class, 'delete'])->name('sms.delete');


Route::get('/admin/settings', [App\Http\Controllers\SettingsController::class, 'index'])->name('setting.index');
Route::post('/admin/settings/store', [App\Http\Controllers\SettingsController::class, 'store'])->name('setting.save');

Route::post('/admin/ppoe/store', [App\Http\Controllers\PackagesController::class, 'storePPoePackage'])->name('ppoe.save');
Route::get('/admin/ppoe/create', [App\Http\Controllers\PackagesController::class, 'createPpoe'])->name('ppoe.create');
Route::get('/admin/ppoe/edit/{id}', [App\Http\Controllers\PackagesController::class, 'editPpoe'])->name('ppoe.edit');
Route::post('/admin/ppoe/update/{id}', [App\Http\Controllers\PackagesController::class, 'editPPoePackage'])->name('ppoe.update');
Route::get('/admin/ppoe/delete/{id}', [App\Http\Controllers\PackagesController::class, 'deletePPoePackage'])->name('ppoe.delete');

//ppoe users
Route::get('/admin/ppoe/users', [App\Http\Controllers\PpoeController::class, 'index'])->name('ppoe.users');
Route::post('/admin/ppoe/user/store', [App\Http\Controllers\PpoeController::class, 'store'])->name('ppoe.user.save');
Route::get('/admin/ppoe/user/create', [App\Http\Controllers\PpoeController::class, 'create'])->name('ppoe.user.create');
Route::get('/admin/ppoe/user/edit/{id}', [App\Http\Controllers\PpoeController::class, 'edit'])->name('ppoe.user.edit');
Route::post('/admin/ppoe/user/update/{id}', [App\Http\Controllers\PpoeController::class, 'update'])->name('ppoe.user.update');
Route::get('/admin/ppoe/user/delete/{id}', [App\Http\Controllers\PpoeController::class, 'delete'])->name('ppoe.user.delete');
Route::get('/admin/ppoe/user/activate/{id}', [App\Http\Controllers\PpoeController::class, 'activate'])->name('ppoe.user.activate');
Route::get('/admin/ppoe/user/deactivate/{id}', [App\Http\Controllers\PpoeController::class, 'deactivate'])->name('ppoe.user.deactivate');


//
//
//Route::prefix('admin')->group(function() {
//
//Route::get('/ppoe', [App\Http\Controllers\PpoeController::class, 'index'])->name('ppoe.home');
//    Route::post('/ppoe/store', [App\Http\Controllers\PpoeController::class, 'insert'])->name('ppoe.store');
//});

Route::get('/test', [App\Http\Controllers\CommonController::class, 'chartTest']);

Route::get('/test2', [App\Http\Controllers\RouterController::class, 'index'])->name('ppoe.users');


Route::get('/upload/users', [App\Http\Controllers\ExcelImportController::class, 'userView'])->name('users.import');
Route::get('/upload/packages', [App\Http\Controllers\ExcelImportController::class, 'packagesView'])->name('packages.import');
Route::post('/upload/users/post', [App\Http\Controllers\ExcelImportController::class, 'storeUsers'])->name('users.import.post');
Route::post('/upload/packages/post', [App\Http\Controllers\ExcelImportController::class, 'storePackages'])->name('packages.import.post');

Route::get('/users/export', [App\Http\Controllers\ExcelImportController::class, 'exportUsers'])->name('users.export');





Route::get('/tickets', [App\Http\Controllers\TicketController::class, 'index'])->name('tickets.index');
Route::get('/tickets/create', [App\Http\Controllers\TicketController::class, 'create'])->name('tickets.create');
Route::get('/tickets/view/{id}', [App\Http\Controllers\TicketController::class, 'show'])->name('tickets.show');
Route::get('/tickets/delete/{id}', [App\Http\Controllers\TicketController::class, 'destroy'])->name('tickets.delete');
Route::get('/tickets/edit/{id}', [App\Http\Controllers\TicketController::class, 'edit'])->name('tickets.edit');
Route::get('/tickets/mark/solved/{id}', [App\Http\Controllers\TicketController::class, 'markResolved'])->name('tickets.solved');
Route::post('/tickets/post', [App\Http\Controllers\TicketController::class, 'store'])->name('tickets.post');
Route::post('/tickets/update/{id}', [App\Http\Controllers\TicketController::class, 'update'])->name('tickets.update');


Route::get('/admin/regions', [App\Http\Controllers\RegionController::class, 'index'])->name('regions.index');
Route::get('admin/regions/create', [App\Http\Controllers\RegionController::class, 'create'])->name('regions.create');
Route::get('admin/regions/view/{id}', [App\Http\Controllers\RegionController::class, 'show'])->name('regions.show');
Route::get('admin/regions/delete/{id}', [App\Http\Controllers\RegionController::class, 'destroy'])->name('regions.delete');
Route::get('admin/regions/edit/{id}', [App\Http\Controllers\RegionController::class, 'edit'])->name('regions.edit');
Route::post('admin/regions/post', [App\Http\Controllers\RegionController::class, 'store'])->name('regions.post');
Route::post('admin/regions/update/{id}', [App\Http\Controllers\RegionController::class, 'update'])->name('regions.update');


Route::get('admin/team/support', [App\Http\Controllers\UsersController::class, 'supportTeam'])->name('team.index');
Route::get('team/support/create', [App\Http\Controllers\UsersController::class, 'createTeam'])->name('team.create');
//Route::get('team/support/view/{id}', [App\Http\Controllers\UsersController::class, 'show'])->name('team.show');
Route::get('team/support/delete/{id}', [App\Http\Controllers\UsersController::class, 'deleteTeam'])->name('team.delete');
Route::get('team/support/edit/{id}', [App\Http\Controllers\UsersController::class, 'editTeam'])->name('team.edit');
Route::post('team/support/post', [App\Http\Controllers\UsersController::class, 'storeTeam'])->name('team.post');
Route::post('team/support/update/{id}', [App\Http\Controllers\UsersController::class, 'updateTeam'])->name('team.update');

Route::get('admin/invoices', [App\Http\Controllers\InvoiceController::class, 'index'])->name('invoices.index');
Route::get('admin/invoice/message/{id}', [App\Http\Controllers\InvoiceController::class, 'invoiceMessage'])->name('invoices.message');
Route::post('admin/invoices/message', [App\Http\Controllers\InvoiceController::class, 'sendInvoiceMessage'])->name('invoices.message.post');
Route::get('sms/test', [App\Http\Controllers\CommonController::class, 'testSms'])->name('sms.test');



Route::get('admin/sales_reports/daily', [App\Http\Controllers\ReportsController::class, 'index']);
Route::get('admin/sales_reports/weekly', [App\Http\Controllers\ReportsController::class, 'weeklyReport']);
Route::get('admin/sales_reports/monthly', [App\Http\Controllers\ReportsController::class, 'monthlyReport']);
Route::get('admin/sales_reports/custom', [App\Http\Controllers\ReportsController::class, 'customReport']);

Route::get('admin/expenses_reports/daily', [App\Http\Controllers\ReportsController::class, 'todayExpense']);
Route::get('admin/expenses_reports/weekly', [App\Http\Controllers\ReportsController::class, 'weeklyExpense']);
Route::get('admin/expenses_reports/monthly', [App\Http\Controllers\ReportsController::class, 'monthlyExpense']);
Route::get('admin/expenses_reports/custom', [App\Http\Controllers\ReportsController::class, 'customExpenseReport']);


Route::get('admin/profit_reports/custom', [App\Http\Controllers\ReportsController::class, 'profitReport']);


Route::get('admin/expenses', [App\Http\Controllers\ExpensesController::class, 'index']);
Route::get('admin/expense/create', [App\Http\Controllers\ExpensesController::class, 'create']);
Route::post('admin/expense/post', [App\Http\Controllers\ExpensesController::class, 'store']);
Route::get('admin/expense/edit/{id}', [App\Http\Controllers\ExpensesController::class, 'edit']);
Route::post('admin/expense/update/{id}', [App\Http\Controllers\ExpensesController::class, 'update']);
Route::get('admin/expense/delete/{id}', [App\Http\Controllers\ExpensesController::class, 'destroy']);


Route::get('/update/profile', [App\Http\Controllers\UsersController::class, 'editProfile'])->name('user.update.profile');
Route::post('/update/profile/post', [App\Http\Controllers\UsersController::class, 'postProfile'])->name('user.post.profile');

