
<?php $__env->startSection('content'); ?>
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Filter By Date Expenses Report</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Filter By Date Expenses Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
           <?php if(session('success')): ?>
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <section class="section">
                <div class="card">
                    <div class="card-header">
                       Filter By Date Expenses Report
                       
                    </div>

                    <div class="card-body">
                      <form action="<?php echo e(url()->current()); ?>" method="GET">
                        <div class="row m-1">

                          
                            <div class="form-group col-12 col-sm-6 col-md-3 col-lg-3">
                                <label class="input-label" for="exampleFormControlInput1">Select from date</label>
                                <input id="start_date" type="date" name="from" class="form-control" value="<?php echo e($from); ?>">
                            </div>

                            <div class="form-group col-12 col-sm-6 col-md-3 col-lg-3">
                                <label class="input-label" for="exampleFormControlInput1">Select to date </label>
                                <input id="end_date" type="date" name="to" class="form-control" value="<?php echo e($to); ?>">
                            </div>


                            <div class="col-12 ">
                                <div class="row d-flex ">
                                    <button class="btn btn-success col-3 mr-1" style="margin-right: 6px;">Filter</button>
                                    <a href="<?php echo e(url('admin/expenses_reports/custom')); ?>" class="btn btn-danger col-3 mr-1">Reset</a>
                                </div>
                            </div>


                    </div>
                    </form>
                         <table class="table table-bordered" id="table1">

                 <thead>
                  <tr>
                    <th>#</th>
                    <th>Amount</th>
                    <th>Date</th>
                     <th>Description</th>
                      <th>Added By</th>
                   
                   
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <th scope="row"><?php echo e($loop->iteration); ?></th>
                    <td><?php echo e(number_format($expense->amount, 2)); ?> Ksh</td>
                   <td><?php echo e($expense->date); ?></td>
                   <td><?php echo e($expense->description); ?></td>
                   <?php
                   $user = App\Models\User::where('id', $expense->user_id)->first();

                   ?>
                    <td><?php echo e($user->name); ?></td>

                   
                  
                  </tr>


                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                </tbody>
                <tr>
                    <td  style=" border-bottom-style: hidden;
                 
                    border-right-style: hidden;
                    border-left-style: hidden;">
                      
                    </td>
                     <td style=" border-bottom-style: hidden;
                    
                    border-right-style: hidden;
                    border-left-style: hidden;"></td>
                      
                       
                    <td style=" border-bottom-style: hidden;
                
                    border-left-style: hidden;"></td>
                    <td style=" border-bottom-style: hidden;
                
                    border-left-style: hidden; border-top-style: hidden; display: none">SalesSalesSalesSalesSalesSalesSal</td>

                          <td style="background-color: #435ebe; color: #fff;">Total Expenses</td>
                  
                       <td style="background-color: #435ebe; color: #fff;"><?php echo e(number_format($total,2)); ?> Ksh</td>
                  </tr>
              </table>
                    </div>
                </div>

            </section>
        </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\swiftnet\resources\views/admin/reports/custom_expense.blade.php ENDPATH**/ ?>