
<?php $__env->startSection('content'); ?>
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Users</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">PPoe Users</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <?php if(session('success')): ?>
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><i class="bi bi-check-circle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        PPoe Users


                        <a href="<?php echo e(url('/admin/ppoe/user/create')); ?>" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New PPoe User</a>

                    </div>

                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                 <th>Location</th>
                                <th>Package</th>
                                <th>Status</th>

                                <th>Created At</th>

                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



                                <tr>
                                    <td><?php echo e($user->name); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->phone); ?></td>
                                     <td><?php echo e($user->location); ?></td>
                                    <?php
                                        if($user->role != 1){
                                        $sub = App\Models\Subscription::where('username',$user->phone)->where('status',1)->first();
                                         }else{
                                         $sub = '';
                                     }
                                        $admin = App\Models\User::where('role',1)->first();
                                        if($sub){
                                              $pac = App\Models\Package::where('id',$sub->package)->first();


                                              if($pac)
                                              {
                                                 $package = $pac->name;
                                             }else{
                                             $package = "Not Subscribed";
                                         }
                                             
                                             // $type = $pac->type;

                                        }else{
                                            $package = 'Not Subscribed';
                                        }


                                    ?>
                                    <td><?php echo e($package); ?></td>
                                    <td>
                                        <?php if($user->role == 1): ?>
                                            <span class="badge bg-success">Active</span>
                                        <?php elseif($user->role != 1): ?>
                                            <?php if($sub): ?>
                                                <?php if($sub->status == 1): ?>

                                                    <span class="badge bg-success">Active</span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger">Inactive</span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Inactive</span>
                                            <?php endif; ?>

                                        <?php endif; ?>
                                    </td>
                                    <?php
                                        $inputDateTime = $user->created_at;
                                    $datep = Illuminate\Support\Carbon::parse($inputDateTime);
                                    $days_ = $datep->longAbsoluteDiffForHumans(Illuminate\Support\Carbon::now());
                                    $daysAgo = $days_;

                                    ?>
                                    <td><?php echo e($daysAgo); ?></td>
                                    <?php if($user->role == 2): ?>
                                        <td>
                                            <div class="btn-group mb-1">
                                                <div class="dropdown">
                                                    <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                            id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        Actions
                                                    </button>
                                                    <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                            <a class="dropdown-item" href="<?php echo e(url('admin/ppoe/user/edit',$user->id)); ?>"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                                Edit</a>


                                                        <a class="dropdown-item" href="<?php echo e(url('user/view',$user->id)); ?>"><i class="fa fa-eye" aria-hidden="true" style="color: #7c8db5;"></i>
                                                            View</a>
                                                        <a class="dropdown-item" href="<?php echo e(url('/admin/ppoe/user/delete',$user->id)); ?>"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i> Delete</a>
                                                       
                                                            <?php if($sub): ?>
                                                            <a class="dropdown-item" href="<?php echo e(url('admin/ppoe/user/deactivate',$user->id)); ?>"><i class="fa fa-ban" aria-hidden="true" style="color: red;"></i>
                                                                        Deactivate</a>
                                                                        <?php else: ?>
                                                        <a class="dropdown-item" href="<?php echo e(url('admin/ppoe/user/activate',$user->id)); ?>"><i class="fa fa-reply" aria-hidden="true" style="color: #7c8db5;"></i>
                                                            Activate</a>
                                                                
                                                                <?php endif; ?>
                                                          

                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    <?php else: ?>
                                        <td>
                                            Admin
                                        </td>
                                    <?php endif; ?>
                                </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\swiftnet\resources\views/admin/users/ppoe/index.blade.php ENDPATH**/ ?>